/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.listener.axis.rm;

import filenet.vw.base.logging.Logger;
import filenet.ws.listener.axis.rm.WSRequestForward;
import filenet.ws.listener.utils.Constants;
import filenet.ws.listener.utils.WSListenerProperties;
import filenet.ws.utils.WSConstants;
import filenet.ws.utils.WSLogger;
import javax.xml.namespace.QName;
import org.apache.axis.AxisFault;
import org.apache.axis.MessageContext;
import org.w3c.dom.Element;

public class WSForwardProcess {
    private WSLogger m_wsLogger = null;
    protected static Logger logger = Logger.getLogger("filenet.ws.listener.axis.rm");
    protected static final String m_className = "WSForwardProcess";

    public static String _get_FILE_DATE() {
        return "$Date:   08 Dec 2008 15:32:22  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   ysoong  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.5  $";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element[] forward(Element[] xml) throws Exception {
        String m_method = "forward";
        logger.entering(m_className, "forward");
        try {
            MessageContext msgContext = MessageContext.getCurrentContext();
            WSRequestForward reqForward = new WSRequestForward();
            int targetPort = Constants.LISTENER_PROPERTY_WSRM_CLIENT_LISTENER_PORT_DEFAULT;
            String targetHost = null;
            WSListenerProperties props = (WSListenerProperties)msgContext.getProperty("MC.P8BPM.LISTENERPROPERTIES");
            this.m_wsLogger = (WSLogger)msgContext.getProperty("MC.P8BPM.WSLOGGER");
            if (props != null) {
                try {
                    targetHost = props.getProperty("filenet.wsrm.client.listener.host");
                    targetPort = Integer.parseInt(props.getProperty("filenet.wsrm.client.listener.port"));
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            MessageContext t = msgContext;
            synchronized (t) {
                reqForward.addRequest(msgContext, targetPort, targetHost);
                msgContext.wait(300000L);
            }
            Boolean forwarded = (Boolean)msgContext.getProperty("MC.P8BPM.RM.FORWARDED");
            if (forwarded != null && !forwarded.booleanValue()) {
                String s = "Message forwarded to " + (targetHost == null ? "localhost" : targetHost) + ":" + targetPort;
                if (logger.isFinest()) {
                    logger.finest(m_className, "forward", s);
                }
                msgContext.setProperty("MC.P8BPM.RM.FORWARDED", (Object)Boolean.FALSE);
                if (this.m_wsLogger != null) {
                    this.m_wsLogger.append(s).eoln();
                }
                Element[] elementArray = null;
                return elementArray;
            }
            String desc = "Timed out!";
            if (logger.isFinest()) {
                logger.finest(m_className, "forward", "Timed out!");
            }
            QName fault = WSConstants.getDefaultWSConstants().FAULT_FORWARD_TIMED_OUT;
            AxisFault retFault = new AxisFault(fault, desc, null, null);
            retFault.addFaultDetail(fault, desc);
            logger.throwing(m_className, "forward", retFault);
            throw retFault;
        }
        finally {
            logger.exiting(m_className, "forward");
            if (this.m_wsLogger != null) {
                this.m_wsLogger.println("WSForwardProcess Exits");
            }
        }
    }
}

